<?php

namespace addons\distinct;

use app\common\library\Menu;
use think\Addons;

/**
 * 插件
 */
class Distinct extends Addons
{

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $menu = [
            [
                'name'    => 'distinct/index',
                'title'   => '数据查重工具',
                'icon'    => 'fa fa-table',
                'ismenu'  => 1,
                'sublist' => [
                    ['name' => 'distinct/index/index', 'title' => '获取数据表'],
                    ['name' => 'distinct/index/get_field_list', 'title' => '获取表字段'],
                    ['name' => 'distinct/index/select', 'title' => '查重'],
                    ['name' => 'distinct/index/delete', 'title' => '一键去重'],
                    ['name' => 'distinct/index/delsinger', 'title' => '单条去重'],
                ]
            ]
        ];
        Menu::create($menu);
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        Menu::delete("distinct/index");
        return true;
    }

    /**
     * 插件启用方法
     * @return bool
     */
    public function enable()
    {
        Menu::enable("distinct/index");
        return true;
    }

    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable()
    {
        Menu::disable("distinct/index");
        return true;
    }
}
