<?php
namespace app\sign\controller;

use think\Controller;
use think\Db;

class Install extends Controller {
    
    public function index() {
        $shortid = input('get.shortid');
        if(empty($shortid)) {
            return '参数错误';
        }

        $info = Db::table('fa_shorturl')
            ->where('shortid', $shortid)
            ->find();
            
        if(!$info) {
            return '安装链接不存在或已过期';
        }

        if($info['cs'] <= 0) {
            return '下载次数已用完';
        }

        // 解密安装信息
        $data = $this->_decrypt($info['url'], '86594471'); 
        $arr = explode(',', $data);
        
        $plist = $this->generatePlist($arr[0], $arr[1], $arr[2], $arr[3]);
        
        // 更新下载次数
        Db::table('fa_shorturl')
            ->where('shortid', $shortid)
            ->setDec('cs');
            
        header('Content-Type: text/xml');
        return $plist;
    }

    private function generatePlist($appname, $icon, $bundleid, $ipaurl) {
        return '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>items</key>
    <array>
        <dict>
            <key>assets</key>
            <array>
                <dict>
                    <key>kind</key>
                    <string>software-package</string>
                    <key>url</key>
                    <string>'.$ipaurl.'</string>
                </dict>
                <dict>
                    <key>kind</key>
                    <string>display-image</string>
                    <key>url</key>
                    <string>'.$icon.'</string>
                </dict>
                <dict>
                    <key>kind</key>
                    <string>full-size-image</string>
                    <key>url</key>
                    <string>'.$icon.'</string>
                </dict>
            </array>
            <key>metadata</key>
            <dict>
                <key>bundle-identifier</key>
                <string>'.$bundleid.'</string>
                <key>bundle-version</key>
                <string>1.0</string>
                <key>kind</key>
                <string>software</string>
                <key>title</key>
                <string>'.$appname.'</string>
            </dict>
        </dict>
    </array>
</dict>
</plist>';
    }

    private function _decrypt($data, $key) {
        $key = md5($key);
        $data = str_replace(['ksq', 'wangbei', 'haha'], ['=', '+', '/'], $data);
        $data = base64_decode($data);
        $expire = substr($data, 0, 10);
        $data = substr($data, 10);
        
        if($expire > 0 && $expire < time()) {
            return '';
        }
        
        $x = 0;
        $len = strlen($data);
        $l = strlen($key);
        $char = $str = '';
        
        for($i = 0; $i < $len; $i++) {
            if($x == $l) $x = 0;
            $char .= substr($key, $x, 1);
            $x++;
        }
        
        for($i = 0; $i < $len; $i++) {
            if(ord(substr($data, $i, 1)) < ord(substr($char, $i, 1))) {
                $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
            } else {
                $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
            }
        }
        return base64_decode($str);
    }
}
