define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'signcs/index' + location.search,
                     add_url: 'signcs/add',
                    edit_url: 'signcs/edit',
                    del_url: 'signcs/del',
                    multi_url: 'signcs/multi',
                    table: 'signcs',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                //sortOrder: "asc",    
                sortName: 'id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'kami', title: __('兑换码')},
                        {field: 'dhtype', title: __('兑换类型'),searchList: { 1: 'VIP', 2: '免费'},formatter: Table.api.formatter.flag},
                        {field: 'cs', title: __('增加签名次数')},
                        {field: 'jh', title: __('状态'),searchList: { 0: '未激活', 1: '激活'},formatter: Table.api.formatter.flag},
                        {field: 'udid', title: __('UDID')},
                         {field: 'addtime', title: __('生成时间'), operate:'RANGE', addclass:'datetimerange', formatter: Table.api.formatter.datetime},
					    {field: 'usetime', title: __('使用时间'), operate:'RANGE', addclass:'datetimerange', formatter: Table.api.formatter.datetime},
					    {field: 'beizhu', title: __('备注')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});