define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'udidlist/index' + location.search,
                     add_url: 'udidlist/add',
                    edit_url: 'udidlist/edit',
                    del_url: 'udidlist/del',
                    multi_url: 'udidlist/multi',
                    table: 'udidlist',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                //sortOrder: "asc",    
                sortName: 'id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'udid', title: __('Udid')},
                         {field: 'product', title: __('设备型号')},
                         {field: 'imei', title: __('设备串号')},
                        {field: 'zsid', title: __('Zsid')},
                        {field: 'chi', title: __('池'),searchList: {0: '公共', 1: '独立'},formatter: Table.api.formatter.flag},
                        {field: 'type', title: __('类型'),searchList: {1: '秒出', 2: '预约'},formatter: Table.api.formatter.flag},
                        {field: 'shtype', title: __('售后类型'),searchList: {0: '躺平版', 1: '标准版', 2: '加强版', 3: '稳定版'},formatter: Table.api.formatter.flag},
                        {field: 'pname', title: __('证书名称')},
                        {field: 'id', title: __('下载证书'), formatter: actionFormatter},
                        {field: 'zt', title: __('状态'),searchList: {0: '掉签', 1: '正常',2: '无证书'},formatter: Table.api.formatter.flag},
                        
                        {field: 'freecs', title: __('免费签名次数')},
                        {field: 'vipcs', title: __('VIP签名次数')},
                       {field: 'disable', title: __('禁用'), formatter:Table.api.formatter.toggle},
					    {field: 'dqtime', title: __('Dqtime'), operate:'RANGE', addclass:'datetimerange', formatter: Table.api.formatter.datetime},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    
 
        
    return Controller;
});

    function actionFormatter(value, row, index) {
    var id = value;
    var result = "";
    if(row['zsid']==null){
        
        result += '<span class="input-group-btn input-group-sm">无证书</span>';
        return result;
        
    }else{
        result += '<span class="input-group-btn input-group-sm"><a onclick="down(`' +row['udid'] + '`)" target="_blank" class="btn btn-default btn-sm"><i class="fa fa-download"></i></a></span>';
               
        return result;
    }
    }
    
function down(udid) {
    
   $.ajax({
        type: 'POST',
        url: "/sign/index/down",
        data: {
            udid:udid,
            },
        dataType: "json",
        success: function(result, textStatus, jqXHR) {
           layer.closeAll('loading');  
           if(result['code']==1){
            
              const textToCopy = result['data']['zip'];
             window.parent.window.location.href = textToCopy;
           }else{
                layer.msg(result['msg']);
           }
        }
        
   });
            
 
} 
        