define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'zsdhm/index' + location.search,
                    add_url: 'zsdhm/add',
                    edit_url: 'zsdhm/edit',
                    del_url: 'zsdhm/del',
                    multi_url: 'zsdhm/multi',
                    table: 'zsdhm',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'kami', title: __('Kami')},
                        {field: 'dhtype', title: __('类型'),searchList: {1: '实时', 2: '预约'},formatter: Table.api.formatter.flag},
                        {field: 'sjyp', title: __('Sjyp'),searchList: {1: '月卡', 2: '半年', 3: '年卡'},formatter: Table.api.formatter.flag},
                        {field: 'type', title: __('证书类型'),searchList: {1: '标准版',2: '加强版', 3: '稳定版', 0: '躺平版'},formatter: Table.api.formatter.flag},
                        
                         {field: 'jh', title: __('Jh'),searchList: {0: '未激活', 1: '已激活'}, formatter: Table.api.formatter.label},
                        {field: 'udid', title: __('Udid')},
					     {field: 'zsid', title: __('Zsid')},
					       {field: 'beizhu', title: __('备注')},
					       {field: 'jhtime', title: __('Jhtime'), operate:'RANGE', addclass:'datetimerange', formatter: Table.api.formatter.datetime},
                       
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});